import { useState, useEffect } from 'react'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import sewing1 from '/images/sewing-1.jpg'
import sewing2 from '/images/sewing-2.jpg'
import sewing3 from '/images/sewing-3.jpg'
import sewing4 from '/images/sewing-4.jpg'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  
  // Заглушки для изображений
  const images = [
    {
      id: 1,
      src: sewing1,
      title: 'Шитье'
    },
    {
      id: 2,
      src: sewing2,
      title: 'Кройка'
    },
    {
      id: 3,
      src: sewing3,
      title: 'Моделирование'
    },
    {
      id: 4,
      src: sewing4,
      title: 'Дизайн'
    }
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-sewing">
      <div className="slider-wrapper-sewing">
        {images.map((img, index) => (
          <div
            key={img.id}
            className={`slide-sewing ${index === currentIndex ? 'active' : ''}`}
          >
            <img src={img.src} alt={img.title} className="slide-image-sewing" />
            <div className="slide-overlay-sewing"></div>
            <div className="slide-content-sewing">
              <h3 className="slide-title-sewing">{img.title}</h3>
            </div>
          </div>
        ))}
      </div>
      <button className="slider-btn-sewing prev-sewing" onClick={goToPrevious}>
        <ChevronLeft className="slider-icon-sewing" size={28} />
      </button>
      <button className="slider-btn-sewing next-sewing" onClick={goToNext}>
        <ChevronRight className="slider-icon-sewing" size={28} />
      </button>
      <div className="slider-dots-sewing">
        {images.map((_, index) => (
          <button
            key={index}
            className={`dot-sewing ${index === currentIndex ? 'active' : ''}`}
            onClick={() => goToSlide(index)}
            aria-label={`Go to slide ${index + 1}`}
          />
        ))}
      </div>
    </div>
  )
}

export default ImageSlider

